/**
  ******************************************************************************
  * @file    openbootloader_conf.h
  * @author  MCD Application Team
  * @brief   Contains Open Bootloader configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef OPENBOOTLOADER_CONF_H
#define OPENBOOTLOADER_CONF_H

/* Includes ------------------------------------------------------------------*/
#include "platform.h"
#include "interface_conf.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/

/* -------------------------------- Device ID ------------------------------- */
#define DEVICE_ID_MSB                     0x00              /* MSB byte of device ID */
#define DEVICE_ID_LSB                     0x88              /* LSB byte of device ID */

/* -------------------------- Definitions for Memories ---------------------- */
#define FLASH_START_ADDRESS               (FLASH_BASE)
#define MAX_FLASH_END_ADDRESS             (FLASH_BASE + 256*1024)

#define RAM_START_ADDRESS                 (SRAM_BASE)
#define MAX_RAM_END_ADDRESS               (SRAM_BASE + 32*1024)

#define SYS_START_ADDRESS                 0x1FFF0000U                  /* System memory address */
#define SYS_END_ADDRESS                   0x1FFF1A00U                  /* System memory end address */

#define OTP_START_ADDRESS                 0x1FFF1A00U                  /* OTP registers address */
#define OTP_END_ADDRESS                   0x1FFF1B00U                  /* OTP end address (1024 bytes) */

#define FT_UID_START_ADDRESS              0x1FFF1B00U                  /* UID FT address */
#define FT_UID_END_ADDRESS                0x1FFF1D00U                  /* UID FT end address */

#define OB_START_ADDRESS                  0x1FFF1D00U                  /* Option bytes registers address */
#define OB_END_ADDRESS                    0x1FFF1E00U                  /* Option bytes end address (512 bytes) */

#define FAC_START_ADDRESS                 0x1FFF1E00U                  /* Factory info start address */
#define FAC_END_ADDRESS                   0x1FFF2000U                  /* Factory info end address  */

#define RDP_LEVEL_0                       0x000000AAU
#define RDP_LEVEL_1                       0x00000055U

#define FLASH_MASS_ERASE                  0xFFFF
//#define FLASH_BANK1_ERASE                 0xFFFE
//#define FLASH_BANK2_ERASE                 0xFFFD

#define FLAHS_SIZE_ADDR                 0x1FFF1FFC
#define FLAHS_BANK_SIZE                (((M32(FLAHS_SIZE_ADDR) & 0x3) + 1) * 32 * 1024)

#define INTERFACES_SUPPORTED              IO_INTERFACES_SUPPORTED
#define MEMORIES_SUPPORTED                MEM_INTERFACES_SUPPORTED

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#endif /* OPENBOOTLOADER_CONF_H */
